local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function getFloatingYModifier(self)
	return math.sin(GetTime()/(350.0+self.Width))*(15.5+self.Height/10)-self.TweakY
end

function main(self)
	if self.State == 0 then
		self.Width = math.floor(rand()*100)
		self.Height = math.floor(rand()*10)
		self.TweakY = math.floor(rand()*20)
		self.BaseY = self.Y
		self.BaseX = self.X
		self.Z = 4001
		self.FWspeed = 0.001
		self.RVspeed = 0.005
		self.lastClawPosX = GetClaw().X
		self.lastClawPosY = GetClaw().Y
		self:SetImage("CUSTOM_ARCANETHIEF")
		self.DrawFlags.Mirror = true
		self.DrawFlags.NoDraw = false
		self.StealingFlag = 0
		self.StealingTimer = 0
		self.SearchingFlag = 0
		self.Panic = 0
		self.rail = -0.9
		if GetClaw().X % 2 == 0 then
			self.Health = 20
		else
			self.Health = 30
		end
		-- -0.4 < 0.0 < 1.0
		self.HitTypeFlags = 50335794
		self.HitRect = {-24,-24,24,24}
		self.InvFrames = GetTime()
		self.dodge = 0
		self.State = 1
	elseif self.State == 1 then
		self:SetFrame(self.I)
		self:AnimationStep()
		if math.abs(self.lastClawPosX - GetClaw().X) > 50 or math.abs(self.lastClawPosY - GetClaw().Y) > 50 then
			self.rail = -0.9
		end
		self.lastClawPosX = GetClaw().X
		self.lastClawPosY = GetClaw().Y
		if (GetClaw().DrawFlags.Mirror and self.StealingFlag == 0) or self.Panic == 1 then
			-- retreat
			if self.rail > 0.2 then
				self.rail = self.rail - self.RVspeed
			end
			if self.Panic == 1 and self.rail < 0.25 then
				self.Panic = 0
			end
			if self.rail < 0.15 then
				self.rail = self.rail + self.FWspeed
			end
		elseif GetClaw().Score > 0 then
			-- advance
			if self.rail <= 0.75 then
				self.rail = self.rail + self.FWspeed
			else
				self.StealingFlag = 1
				self.I = 2
			end
		end
		
		local claw = GetClaw()
		
		if self.StealingFlag == 1 then
			if claw.Score <= 0 then
				self.StealingFlag = 0
				self.Panic = 1
				self.SearchingFlag = 0
				self.I = 1
			elseif self.SearchingFlag == 0 then
				self.SearchingFlag = 1
				self.StealingTimer = GetTime()
			elseif self.StealingTimer + 500 < GetTime() then
				if claw.Health > 0 then
					if claw.Score >= 1500 and rand()>0.8 then
						claw.Score = claw.Score - 1500
						PlaySound("GAME_RINGS")
					elseif claw.Score >= 500 and rand()>0.6 then
						claw.Score = claw.Score - 500
						PlaySound("GAME_TREASURE")
					else
						claw.Score = claw.Score - 100
						PlaySound("GAME_COIN")
					end
				end
				self.StealingTimer = GetTime()
			end
		end
		--TextOut(self.StealingTimer)
		
		self.BaseX = claw.X - 320 + 320 * self.rail
		self.BaseY = claw.Y + self.dodge
		if self.dodge < 0 then
			self.dodge = self.dodge + 1
		end
		
		self.X = self.BaseX
		self.Y = self.BaseY + getFloatingYModifier(self)
		
		--TextOut(self.rail)
	end
	
end

function hit(self)
	
	if self.InvFrames + 400 < GetTime() then
		self.InvFrames = GetTime()
		--TextOut(self.HitRef.ObjectTypeFlags)
		if self.HitRef.ObjectTypeFlags == 2 or self.SearchingFlag == 1 then
			if self.State == 9 then
				PlaySound("LEVEL_BLOCK2")
			else
				self.TempStunCounter = GetTime() + 500
				CreateObject {x=self.X, y=self.HitRef.Y, z=9000, name="EnemyHit", logic="CustomLogic", image="GAME_ENEMYHIT"}
				local r = rand()
				if r<0.25 then
					PlaySound("GAME_HIT1")
				elseif r<0.5 then
					PlaySound("GAME_HIT2")
				elseif r<0.75 then
					PlaySound("GAME_HIT3")
				else
					PlaySound("GAME_HIT4")
				end
				if self.HitRef.ObjectTypeFlags == 2 then
					if GetClaw().State == 26 then
						if _CurrentPowerup[0] == 9916 then
							self.Health = self.Health - 10
						else
							self.Health = self.Health - 5
						end
					else
						if _CurrentPowerup[0] == 9916 then
							self.Health = self.Health - 20
						else
							self.Health = self.Health - 10
						end
					end
				elseif self.SearchingFlag == 1 then
					if self.HitRef.ObjectTypeFlags == 32 then
						self.Health = self.Health - 20
						self.HitRef.Y = 9900
					else
						self.Health = self.Health - 30
					end
				end
				self.StealingFlag = 0
				self.SearchingFlag = 0
				self.Panic = 1
				self.I = 1
			end
		elseif self.HitRef.ObjectTypeFlags == 32 then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		elseif self.HitRef.Logic==Dynamite then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		elseif self.HitRef.Logic==PowderKeg then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		elseif self.HitRef.Logic==MagicBullet then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		elseif self.HitRef.Logic==FireBullet then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		elseif self.HitRef.Logic==IceBullet then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		elseif self.HitRef.Logic==LightningBullet then
			self.dodge = self.dodge - 90
			self.rail = self.rail - 0.02
			PlaySound("CUSTOM_TRIGGER_SLIP")
		end
	end
	if self.Health <= 0 then
		CreateObject {x=self.X, y=self.Y, z=3950, name="Explosion", logic="CustomLogic", image="CUSTOM_EXPLOSION"}
		PlaySound("CUSTOM_TRIGGER_BURNING1")
		self:Destroy()
	end
end
